
/***************************************************************************
*  
*  PROGRAM   Using DZ60, the program will switch from FEI mode
*            to PEE Mode
*  
*  AUTHOR    Steven McLaughlin, Application Engineer, East Kilbride
*
*  DATE      August 2007
*
*  NOTES     
*
****************************************************************************/

 /******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       main.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/
 
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MC9S08DZ60.h"


/*****************************************************************************
*
*  FUNCTION    main
*
*  DESCRIPTION  - main routine
*               - sets up the MCG to switch from inital mode of FEI to 
*                 PEE.
*
*  RETURNS     None
*
*  NOTES:
*
*  Fext = 4MHz (ext crystal)
*  want to change the bus frequency to 8MHz and will do this 
*  by switching modes from FEI to PEE
*
*  Fmcgout = [(Fext/R)*M/B] - for PEE mode
*  Fbus = Fmcgout/2
*  
*******************************************************************************/
void main(void) {

     /*Disable COP*/
     SOPT1_COPT=0b00;
          
    
    /*Set up the clock registers */
    
 /************************MCG Control Register 2 (MCGC2)*******************************
* 
*      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
*    --------- --------- --------- --------- --------- ---------- --------- ---------
*   |       BDIV        | RANGE   |   HGO   |   LP    |   EREFS  | ERCLKEN | EREFSTEN|
*   ------------------- --------- --------- --------- ---------- --------- ---------
*   |   0         0     |    1    |    1    |    0    |     1    |    1    |    0    |
*    ------------------- --------- --------- --------- ---------- --------- --------
*
*
*   BDIV     = 00    Set clock to divide by 1 
*   RANGE    = 1     High Freq range selected (i.e. 4MHz in high freq range)                      
*   HGO      = 1     Ext Osc configured for high gain                
*   LP       = 0     FLL or PLL is not disabled in bypass modes
*   EREFS    = 1     Oscillator requested
*   ERCLKEN  = 1     MCGERCLK active 
*   EREFSTEN = 0     Ext Reference clock is disabled in stop
*
**************************************************************************************/
    MCGC2=0b00110110;
    
    /* Loop until OSCINIT = 1 - indicates crystal selected by EREFS bit has been initalised*/
    while(MCGSC_OSCINIT!=1);
    

/************************MCG Control Register 1 (MCGC1)*********************************
*
*      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
*    --------- --------- --------- --------- --------- ---------- --------- ---------
*    |       CLKS        |            RDIV             |  IREFS   |IRCLKEN  |IREFSTEN |
*     ------------------- --------- --------- --------- ---------- --------- ---------
*    |   1         0     |    1    |    1    |    1    |     0    |    0    |    0    |
*     ------------------- --------- --------- --------- ---------- --------- --------
*
*
*    CLKS     = 10    Select Ext reference clk as clock source 
*    RDIV     = 111   Set to divide by 128 (i.e. 4MHz/128 = 31.25kHz - in range required by FLL)                      
*    IREFS    = 0     Ext Ref clock selected
*    IRCLKEN  = 0     MCGIRCLK inactive
*    IREFSTEN = 0     Internal ref clock disabled in stop               
*
***************************************************************************************/
    MCGC1=0b10111000;
    
    /*loop until IREFST = 0 - indicates ext ref is current source*/
    while(MCGSC_IREFST!=0);
    
    /*loop until CLKST = 10 - indiates ext ref clk selected to feed MCGOUT*/
    while(MCGSC_CLKST!=0b10);
  
  /*-------------------------ABOVE CODE ALLOWS ENTRY FROM FEI TO FBE MODE--------------------*/

  
/************************MCG Control Register 1 (MCGC1)*********************************
*
*      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
*    --------- --------- --------- --------- --------- ---------- --------- ---------
*    |       CLKS        |            RDIV             |  IREFS   |IRCLKEN  |IREFSTEN |
*     ------------------- --------- --------- --------- ---------- --------- ---------
*    |   1         0     |    0    |    1    |    0    |     0    |    0    |    0    |
*     ------------------- --------- --------- --------- ---------- --------- --------
*
*
*   CLKS     = 10    Select Ext reference clk as clock source 
*   RDIV     = 010   Set to divide by 4 (i.e. 4MHz/4 = 1 MHz - in range required by FLL)                      
*   IREFS    = 0     Ext Ref clock selected
*   IRCLKEN  = 0     MCGIRCLK inactive
*   IREFSTEN = 0     Internal ref clock disabled in stop                
*
***************************************************************************************/

    MCGC1=0b10010000;
    
/************************MCG Control Register 3 (MCGC3)*********************************
*
*      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
*     --------- --------- --------- --------- --------- ---------- --------- ---------
*    | LOLIE   |  PLLS   |   CME   |    0    |                 VDIV                   |
*     --------- --------- --------- --------- --------- ---------- --------- ---------
*    |   0     |    1    |    0    |    0    |    0    |     1    |    0    |    0    |
*     --------- --------- --------- --------- --------- ---------- --------- --------
*
*
*    LOLIE = 0    No request on loss of lock
*    PLLS  = 1    PLL selected
*    CME   = 0    Clock monitor is disabled
*    VDIV  = 0100 Set to multiply by 16 (1Mhz ref x 16 = 16MHz)                    
* 
*****************************************************************************************/

    MCGC3=0b01000100;
    
    /*loop until PLLST=1 - indicates current source for PLLS is PLL*/
    while(MCGSC_PLLST!=1);
    
    /*loop until LOCK=1 - indicates PLL has aquired lock*/
    while(MCGSC_LOCK!=1);
    
    /*--------------------ABOVE CODE ALLOWS ENTRY FROM FBE TO PBE MODE ------------------*/
    
/*************************MCG Control Register 1 (MCGC1)**********************************
*
*      bit 7	    bit 6     bit 5     bit 4 	   bit 3	  bit 2	    	bit 1	    bit 0
*    --------- --------- --------- --------- --------- ---------- --------- ---------
*   |       CLKS        |            RDIV             |  IREFS   |IRCLKEN  |IREFSTEN |
*    ------------------- --------- --------- --------- ---------- --------- ---------
*   |   0         0     |    0    |    1    |    0    |     0    |    0    |    0    |
*     ------------------- --------- --------- --------- ---------- --------- --------
*
*
*   CLKS     = 00    Select PLL clock source 
*   RDIV     = 100   Set to divide by 4 (i.e. 4MHz/4 = 1 MHz - in range required by PLL)                      
*   IREFS    = 0     Ext Ref clock selected
*   IRCLKEN  = 0     MCGIRCLK inactive
*   IREFSTEN = 0     Internal ref clock disabled in stop               
*
*******************************************************************************************/

    MCGC1=0b00010000;


    /*loop until CLKST =11 - PLL O/P selected to feed MCGOUT in current clk mode*/
    while(MCGSC_CLKST!=0b11);

    
    /*--------------------------ABOVE CODE ALLOWS ENTRY FROM PBE TO PEE MODE------------------*/
    
/**********************************************************************************************
*
* Therefore, RDIV - 4
*            BDIV - 1
*            VDIV - 16
*
*            Fmcgout = [(4MHz/4)*16]/1
*                    = 16MHz
*
*  Also         Fbus = Fmcgout/2
*                    = 8MHz
*
*  Note: Expect the MCLK to display clk.
*
***********************************************************************************************/ 

     
     
    /*Output the clock on PTA0 using MCLK - set the MCSEL bits on SOPT2 register to divide by 1*/ 
    SOPT2 = 0b10000001;



  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
